@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

:SetHomeDir
set HomeDir=%~dp0
rem set HomeDir=%HomeDir:~0,-1%
for %%i in ("%HomeDir%") do set HomeDir=%%~fi

:SetProductInstaller
set Installer=OPC Core Components Redistributable x64.msi
set Arguments=/qb
set ProductId=OPC Core Components Redistributable (x64) 105.1
set DisplayId={40656A0A-4B04-43D7-8F68-32B55B2A156D}

:PrintGreetings
echo "%ProductId%" installer.
echo.

:CheckIsInstallerExists
if not exist "%HomeDir%\%Installer%" (
 echo Failed: %Installer% not found.
 call :Sleep 5 Wait . & echo.
 call :SetErrorLevel 1
 goto :EOF
)

:CheckIsAlreadyInstalled
call :ReadProductId Product "%DisplayId%"
if "!Product!" == "%ProductId%" (
 echo "%ProductId%" is already installed.
 call :Sleep 5 Wait . & echo.
 call :SetErrorLevel 0
 goto :EOF
)

:StartInstaller
echo Start installer "%ProductId%"
echo Start directory "%HomeDir%"
pushd "%HomeDir%" || goto :CouldNotInstall
call :RunPredInstall
call :RunInstaller "%Installer%" %Arguments%
call :RunPostInstall
call :CheckProductId
popd
goto :EOF

:RunInstaller
if /i "%~x1" == ".msi" goto :RunInstallerMsi
goto :RunInstallerExe

:RunInstallerExe
call :Execute %*
goto :EOF

:RunInstallerMsi
call :Execute msiexec.exe /i %*
goto :EOF

:RunPredInstall
goto :EOF

:RunPostInstall
goto :EOF

:CouldNotInstall
echo Fail call pushd "%HomeDir%"
echo Could not install "%ProductId%"
call :SetErrorLevel 1
goto :EOF

:CheckProductId
call :ReadProductId Product "%DisplayId%"
if "!Product!" == "%ProductId%" (
 echo *****************************
 echo Installation Result: SUCCESS.
 echo *****************************
 call :SetErrorLevel 0
) else (
 echo ****************************
 echo Installation Result: FAILED.
 echo ****************************
 call :SetErrorLevel 1
)
goto :EOF

:ReadProductId
rem Usage = call :ReadProductId Product DisplayName
rem Product is variable name for Product Identifier
rem DisplayName is HKLM\..\Uninstall\DisplayName Id
if "%~1" == "" goto :EOF
set %~1=ProductNotFound.
if "%~2" == "" goto :EOF
if defined ProgramFiles call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\Software\Microsoft\Windows\CurrentVersion\Uninstall\%~2" DisplayName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKLM\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:64
if defined ProgramFiles call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:32
if defined ProgramW6432 call :RegQueryString "%~1" "HKCU\SOFTWARE\Classes\Installer\Products\%~2" ProductName /reg:64
goto :EOF

:RegQueryString
rem Usage = call :RegQuery Variable Key Name Option
for /F "tokens=1,2*" %%x in ('reg query "%~2" /v "%~3" %~4 2^> nul') do if /I "%%x" == "%~3" if /I "%%y" == "REG_SZ" set %~1=%%z
goto :EOF

:Sleep
rem Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
SetLocal EnableExtensions EnableDelayedExpansion
if not "%~2" == "" call :ShowSleepProgress %~2
if not "%~3" == "" (for /L %%i in (1,1,%1) do (call :SleepSilent 1 & call :ShowSleepProgress %~3)) else (call :SleepSilent %1)
EndLocal
goto :EOF

:SleepSilent
rem Usage = call :SleepSilent NumSeconds
SetLocal EnableExtensions EnableDelayedExpansion
set /a NumSeconds=%1+1
ping -n %NumSeconds% 127.0.0.1 > nul 2>&1
EndLocal
goto :EOF

:ShowSleepProgress
rem Usage = call :ShowSleepProgress Message
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p Dummy=%*
EndLocal
goto :EOF

:DeleteFiles
rem Usage = call :DeleteFiles file1 file2 ...
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF

:IfProcessNameExistDo
rem Usage = call :IfProcessNameExistDo name.exe command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "imagename eq %~1"') do if /i "%%i" == "%~1" ( %2 %3 %4 %5 %6 %7 %8 %9 & goto :EOF )
goto :EOF

:IfProcessTitleExistDo
rem Usage = call :IfProcessTitleExistDo "window title" command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "windowtitle eq %~1"') do if /i "%%i" == "%~1" ( %2 %3 %4 %5 %6 %7 %8 %9  & goto :EOF )
goto :EOF

:IfProcessNameTitleExistDo
rem Usage = call :IfProcessNameTitleExistDo name.exe "window title" command
if "%~1" == "" goto :EOF
for /f %%i in ('tasklist /nh /fi "imagename eq %~1" /fi "windowtitle eq %~2"') do if /i "%%i" == "%~1" ( %3 %4 %5 %6 %7 %8 %9 & goto :EOF )
goto :EOF

:IfExistExecute
rem Usage = call :IfExistExecute filename args
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
call :Execute %*
goto :EOF

:Execute
rem Usage = call :Execute command
if "%~1" == "" goto :EOF
echo %*
call %*
goto :EOF

:SetErrorLevel
rem Usage = call :SetErrorLevel exitcode
exit /b %1
goto :EOF
